const { registerPaymentMethod } = wc.wcBlocksRegistry;
const { createElement } = wp.element;
const { __ } = wp.i18n;

/**
 * Component for displaying Nexzoneo payment option
 */
const NexzoneoComponent = ({ settings }) => {
    const description = settings?.description || __('Pay securely with your credit card, debit card, or bank transfer via Nexzoneo', 'woocommerce-nexzoneo');
    
    return createElement(
        'div', 
        { 
            className: 'nexzoneo-payment-method',
            role: 'presentation'
        },
        createElement('p', {}, description)
    );
};

/**
 * Component for editing Nexzoneo payment option in admin
 */
const NexzoneoEdit = ({ settings }) => {
    return createElement(
        'div',
        { 
            className: 'nexzoneo-payment-method-edit',
            role: 'presentation'
        },
        createElement('p', {}, __('Nexzoneo payment method', 'woocommerce-nexzoneo'))
    );
};

/**
 * Check if payment method should be available
 */
const canMakePayment = (settings) => {
    const isEnabled = settings?.enabled === 'yes';
    const hasCredentials = settings?.hasCredentials === 'yes';
    const isSSL = window.location.protocol === 'https:';
    
    return isEnabled && hasCredentials && isSSL;
};

/**
 * Payment method configuration
 */
const nexzoneoPaymentMethod = {
    name: 'nexzoneo',
    label: createElement(
        'span', 
        { className: 'nexzoneo-label' }, 
        __('Credit Card / Debit Card', 'woocommerce-nexzoneo')
    ),
    content: createElement(NexzoneoComponent, { settings: window.nexzoneoSettings }),
    edit: createElement(NexzoneoEdit, { settings: window.nexzoneoSettings }),
    canMakePayment: () => canMakePayment(window.nexzoneoSettings),
    ariaLabel: __('Nexzoneo Payment', 'woocommerce-nexzoneo'),
    supports: {
        features: ['products'],
        showSavedCards: false,
        showSaveOption: false,
        isGatewayConfig: true
    },
    tooltipText: __('Pay securely with your credit card, debit card, or bank transfer via Nexzoneo', 'woocommerce-nexzoneo'),
    paymentMethodId: 'nexzoneo',
};

try {
    registerPaymentMethod(nexzoneoPaymentMethod);
} catch (error) {
    console.error('Failed to register Nexzoneo payment method:', error);
}